unit ImageTestMainUnit;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.Memo.Types,
  FMX.ScrollBox, FMX.Memo, FMX.Controls.Presentation, FMX.StdCtrls, FMX.Objects;

type
  tImageTestMainForm = class(TForm)
    ButtonPress: TButton;
    Memo1: TMemo;
    Image1: TImage;
    Timer1: TTimer;
    ButtonExit: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ButtonPressClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ButtonExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ImageTestMainForm : tImageTestMainForm;

implementation

{$R *.fmx}



var
   xvalue :  integer;
   wvalue : single;
   initialised : boolean;
   Scale : real;

procedure tImageTestMainForm.ButtonExitClick(Sender: TObject);
begin
   Application.Terminate;
end;

procedure tImageTestMainForm.ButtonPressClick(Sender: TObject);
var
   Rect : tRectF;
   Brush : tBrush;
begin
   xvalue := 0;
   Timer1.Interval := 100;
   Timer1.Enabled := true;

   Image1.Position.X := 5;
   Image1.Width := ClientWidth - 10;
   Image1.Bitmap.SetSize(trunc(Image1.Width), trunc(Image1.Height));

   Brush := tBrush.Create(tBrushkind.Solid, tAlphaColorRec.White);
   Rect.Create(0, 0, Image1.Width, Image1.Height);

   Image1.Bitmap.Canvas.BeginScene;
   Image1.Bitmap.Canvas.FillRect(Rect, 1, Brush);
   Image1.Bitmap.Canvas.EndScene;

   Brush.Free;
end;

procedure tImageTestMainForm.FormActivate(Sender: TObject);
begin
   if Initialised then  exit;

   Initialised := true;

   xvalue := 0;

   Image1.Width := ClientWidth - 20;
   Image1.Bitmap.SetSize(trunc(Image1.Width), trunc(Image1.Height));

   wvalue := Image1.Width / 30;

   Memo1.Lines.Add('Clientwidth ' + inttostr(ClientWidth) + ', wvalue ' + floattostr(wvalue));
   Memo1.Lines.Add('Image width ' + inttostr(round(Image1.Width)));

   Scale := Image1.Scene.GetSceneScale;
   Memo1.Lines.add('SceneScale = ' + FloatToStr(Scale));
end;

procedure tImageTestMainForm.FormCreate(Sender: TObject);
begin
   Memo1.Text := 'This is to show how the width of an image needs the use of "scale" ' +
        ' to gel with the FillRect parameters.  What a mess!';
   Initialised := false;
end;

procedure tImageTestMainForm.Timer1Timer(Sender: TObject);
var
   Rect : tRectF;
   Brush : tBrush;
   Colour : tAlphaColor;
begin
   case xvalue of
   0..9:    Colour := tAlphaColorRec.Blue;
   10..19:  Colour := tAlphaColorRec.Yellow;
   20..29:  Colour := tAlphaColorRec.Red;
   else     Colour := tAlphaColorRec.Black;
   end;

   Brush := tBrush.Create(tBrushKind.Solid, Colour);

   Rect:= tRectf.Create(5 + wvalue * xvalue, 0, 5 + wvalue * (xvalue + 1), Image1.Height);

   Rect.Left := Rect.Left / Scale;
   Rect.Right := Rect.Right / Scale;
   Memo1.Lines.Add('Right: ' + inttostr(round(Rect.Right)));

   Image1.Bitmap.Canvas.BeginScene;
   Image1.Bitmap.Canvas.FillRect(Rect, 1, Brush);
   Image1.Bitmap.Canvas.EndScene;

   xvalue := xvalue + 1;

   if xvalue >= 31 then timer1.Enabled := false;
   Brush.Destroy;
end;


end.
